// Arapuca simulation
// Authors: L. Paulucci & F. Marinho
// Date: 20th September 2016
//
// Added modifications should be reported in arapuca.cc header comments

#include "G4SystemOfUnits.hh"
#include "G4SteppingManager.hh"

#include "SteppingAction.hh"
#include "RunAction.hh"
#include "EventAction.hh"
#include "DetectorConstruction.hh"
#include "G4Alpha.hh"
#include "g4root.hh"

SteppingAction::SteppingAction(RunAction* run, DetectorConstruction* det)
:fRun(run),fDetector(det)
{ 
  idx=0;
  eveti = 0;
}

SteppingAction::~SteppingAction()
{ 

  for(p=imap.begin(); p!=imap.end(); p++){
    G4cout << p->first << " " << p->second << G4endl;
  }

}

void SteppingAction::UserSteppingAction(const G4Step* aStep)
  
{ 
  
  G4cout << "evt: "<< fRun->GetNumEvent();
  G4cout << ", pdg: " << aStep->GetTrack()->GetDynamicParticle()->GetPDGcode();
    G4cout << ", name: " << aStep->GetTrack()->GetDynamicParticle()->GetDefinition()->GetParticleName();
    G4cout << ", pid: " << aStep->GetTrack()->GetTrackID();
    G4cout << ", mid: " << aStep->GetTrack()->GetParentID();
    G4cout << ", x:   " << aStep->GetTrack()->GetPosition().x()/um;
    G4cout << ", y:   " << aStep->GetTrack()->GetPosition().y()/um;
    G4cout << ", z:   " << aStep->GetTrack()->GetPosition().z()/um;
    G4cout << ", de:  " << aStep->GetTotalEnergyDeposit()/eV;
    G4cout << ", e:   " << aStep->GetTrack()->GetKineticEnergy()/eV;
    G4cout <<  G4endl;
    if(aStep->GetTrack()->GetNextVolume()!=0){
      //G4cout << ", vol: " << aStep->GetTrack()->GetNextVolume()->GetName();
      std::pair<int,int> aux = VolumeCode( aStep->GetTrack()->GetNextVolume()->GetName());
      //G4cout << " " << aux.first;
      //G4cout << " " << aStep->GetPostStepPoint()->GetTouchableHandle()->GetReplicaNumber();
      if(aStep->GetPostStepPoint()->GetTouchableHandle()->GetVolume()->GetName()!="World"){
	//G4cout << " " << aStep->GetPostStepPoint()->GetTouchableHandle()->GetVolume(1)->GetName();
	//G4cout << " " << aStep->GetPostStepPoint()->GetTouchableHandle()->GetReplicaNumber(1);
	//G4cout << " " << aux.second;
      }else{
	//G4cout << " " << "OutOfWorld";
	//G4cout << " " << aux.second;
        //G4cout << " " << 0;
       
      }
    }else{
      std::pair<int,int> aux = VolumeCode("OutOfWorld");
      //G4cout << ", vol: OutOfWorld";
      //G4cout << " " << aux.first;
      //G4cout << " " << 0;
      //G4cout << " " << "OutOfWorld";
      //G4cout << " " << aux.second;
      //G4cout << " " << 0;

    }     
    
    if(aStep->GetPostStepPoint()->GetProcessDefinedStep()!=NULL){
      std::string name = aStep->GetPostStepPoint()->GetProcessDefinedStep()->GetProcessName();
      //G4cout << ", proccess: " << name << G4endl;
      p = imap.find(name);
      if(p!=imap.end()){
	//###G4cout << "repeated" <<" "<< p->first <<" "<< p->second << G4endl;
      }
      if(p==imap.end()){
	idx++;
	std::pair<std::string, int> aux(name,idx);
	imap.insert(aux);
      }

      if(eveti!=fRun->GetNumEvent()){
	eveti=fRun->GetNumEvent();
	for(p=imap.begin(); p!=imap.end(); p++){
	  //G4cout << p->first << " " << p->second << G4endl;
	}
	//G4cout << "n: " << idx << G4endl;
      }
      
    }else{
      //G4cout << ", proccess: User Limit" << G4endl;
    }

}

std::pair<int,int> SteppingAction::VolumeCode(std::string name){

  if(name=="OutOfWorld"){std::pair<int,int> aux(-1,-1); return aux;}
  if(name=="World"){std::pair<int,int> aux(0,-1); return aux;}
  else{
  std::pair<int, int> aux(-3,-4);
  return aux;
  }

}

