#include "G4UImanager.hh"
#include "Randomize.hh"

#include "RunAction.hh"
#include "g4root.hh"

RunAction::RunAction(DetectorConstruction* det) 
:fDetector(det)
{   
  fSaveRndm = 0;  
}

RunAction::~RunAction()
{
}

void RunAction::BeginOfRunAction(const G4Run*)
{  
  
  // save Rndm status
  if (fSaveRndm > 0)
    { 
      CLHEP::HepRandom::showEngineStatus();
      CLHEP::HepRandom::saveEngineStatus("beginOfRun.rndm");
    }
 
  fNumEvent = 0;
  
}

void RunAction::EndOfRunAction(const G4Run* /*aRun*/)
{     
  
  // save Rndm status
  if (fSaveRndm == 1)
  { 
    CLHEP::HepRandom::showEngineStatus();
    CLHEP::HepRandom::saveEngineStatus("endOfRun.rndm");
  }   
  
  G4cout << G4endl;    
        
  delete G4AnalysisManager::Instance();

}
