#include "DetectorConstruction.hh"
#include "G4PhysicalConstants.hh"
#include "G4SystemOfUnits.hh"
#include "G4NistManager.hh"

#include "G4Color.hh"
#include "G4VisAttributes.hh"

DetectorConstruction::DetectorConstruction()
  
  :fDefaultMaterial(NULL),
   fPhysiWorld(NULL),fLogicWorld(NULL),fSolidWorld(NULL)
  
{
  fWorldSizeXY=fWorldSizeZ=0;

}  
DetectorConstruction::DetectorConstruction(double size)
  
  :fDefaultMaterial(NULL),
   fPhysiWorld(NULL),fLogicWorld(NULL),fSolidWorld(NULL)
  
{
  fWorldSizeXY=fWorldSizeZ=0;
  fsize = size;
  
}  

DetectorConstruction::~DetectorConstruction()
{
  delete fDefaultMaterial;

}

G4VPhysicalVolume* DetectorConstruction::Construct()
  
{
  DefineMaterials();
  return ConstructLine();
}

void DetectorConstruction::DefineMaterials()
{  

  G4NistManager * man = G4NistManager::Instance();
  G4Material* env_mat = man->FindOrBuildMaterial("G4_lAr");

  G4cout << G4endl << *(G4Material::GetMaterialTable()) << G4endl;

  fDefaultMaterial = env_mat;

}

G4VPhysicalVolume* DetectorConstruction::ConstructLine()
{
  // WORLD
  fWorldSizeXY  = 10*m;  fWorldSizeZ   = 10*m;
       
  fSolidWorld = new G4Box("World",			         //name
		  fWorldSizeXY/2,fWorldSizeXY/2,fWorldSizeZ/2);  //size
  
  fLogicWorld = new G4LogicalVolume(fSolidWorld,	//solid
				    fDefaultMaterial,	//material
				    "World");		//name
  
  fPhysiWorld = new G4PVPlacement(0,			//no rotation
  				 G4ThreeVector(),	//at (0,0,0)
                                 "World",		//name
                                 fLogicWorld,		//logical volume
                                 NULL,			//mother volume
                                 false,			//boolean operation
                                 0);			//copy number

  return fPhysiWorld;
}


