// Arapuca simulation
// Authors: L. Paulucci & F. Marinho
// Date: 20th September 2016
//
// Added modifications should be reported in arapuca.cc header comments

#ifndef DetectorConstruction_h
#define DetectorConstruction_h 1

#include "G4VUserDetectorConstruction.hh"
#include "G4Box.hh"
#include "G4SubtractionSolid.hh"
#include "G4Cons.hh"
#include "G4Material.hh"
#include "G4PVPlacement.hh"
#include "G4OpticalSurface.hh"
#include "G4LogicalSkinSurface.hh"
#include "G4LogicalBorderSurface.hh"
#include "G4UserLimits.hh"
#include "G4PVParameterised.hh"

#include "G4EqMagElectricField.hh"
#include "G4PropagatorInField.hh"
#include "G4TransportationManager.hh"
#include "G4ChordFinder.hh"
#include "G4ClassicalRK4.hh"

class DetectorConstruction : public G4VUserDetectorConstruction
{
public:

  DetectorConstruction();
  DetectorConstruction(double size);
  ~DetectorConstruction();

  G4VPhysicalVolume* Construct();
    
private:

  G4double fsize;

  G4double      fWorldSizeXY;
  G4double      fWorldSizeZ;
 
// Materials

  G4Material*   fDefaultMaterial;
  G4Material*   fTPB;

// Volumes

  G4VPhysicalVolume* fPhysiWorld;
  G4LogicalVolume*   fLogicWorld;  
  G4Box*             fSolidWorld;

  G4VPhysicalVolume*  tpbPhys;
  G4LogicalVolume*    tpbLogic;  
  G4Box*              tpbSolid;
  
  void DefineMaterials();
  G4VPhysicalVolume* ConstructLine();     

};

#endif
